package imi.pmf.sprint;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import java.util.ArrayList;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;

class ZadatakTest {

    Zadatak zadatak; // System Under Test

    @BeforeEach
    void setUp(){
        zadatak = new Zadatak("Validacija forme", "Definisati validatore forme.");
    }

    @Test
    void azurirajStatusBlokiranogZadatka() {
        // arrange
        Zadatak zadatak1 = Mockito.mock(Zadatak.class);
        Zadatak zadatak2 = Mockito.mock(Zadatak.class);
        Zadatak zadatak3 = Mockito.mock(Zadatak.class);

        Mockito.when(zadatak1.getStatus()).thenReturn(Status.ZAVRSEN);
        Mockito.when(zadatak2.getStatus()).thenReturn(Status.U_VERIFIKACIJI);
        Mockito.when(zadatak2.getNaziv()).thenReturn("Obrada podataka u formi");
        Mockito.when(zadatak3.getStatus()).thenReturn(Status.U_IZRADI);

        List<Zadatak> neSmePocetiPre = new ArrayList<>();
        neSmePocetiPre.add(zadatak1);
        neSmePocetiPre.add(zadatak2);
        neSmePocetiPre.add(zadatak3);
        zadatak.setNeSmePocetiPre(neSmePocetiPre);

        // act
        BlokiranZadatakException exception =  assertThrows(
                BlokiranZadatakException.class, ()-> zadatak.azurirajStatus());

        // assert
        assertEquals("Zadatak 'Validacija forme' je blokiran od 'Obrada podataka u formi'",
                exception.getMessage());
    }

    @Test
    public void azurirajStatusNeblokiranogZadatka(){
        Zadatak zadatak1 = Mockito.mock(Zadatak.class);
        Zadatak zadatak2 = Mockito.mock(Zadatak.class);

        Mockito.when(zadatak1.getStatus()).thenReturn(Status.ZAVRSEN);
        Mockito.when(zadatak2.getStatus()).thenReturn(Status.ZAVRSEN);
        List<Zadatak> neSmePocetiPre = new ArrayList<>();
        neSmePocetiPre.add(zadatak1);
        neSmePocetiPre.add(zadatak2);
        zadatak.setNeSmePocetiPre(neSmePocetiPre);

        // act
        boolean rezultat = false;
        try {
            rezultat = zadatak.azurirajStatus();
        } catch (BlokiranZadatakException e) {
            fail(e.getMessage());
        }

        // assert
        assertTrue(rezultat);
        assertEquals(Status.U_IZRADI, zadatak.getStatus());
    }
}